/*
 * @(#)ZipMenuAction.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.AbstractButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;


/**
 * Class used to make the Action menu in the menu bar
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipMenuAction extends JMenu {

    // private members
    private JMenuItem AddItem;
    private JMenuItem ExtractItem;
    private JMenuItem DeleteItem;
    private JMenuItem AboutItem;
    

    /**
     * Constructor of the class
     * @param allActionListener the global listener
     */
    public ZipMenuAction(AllActionListener allActionListener) {
	super("Action");

	// create the menu items
	AddItem = new JMenuItem("Add");
	ExtractItem = new JMenuItem("Extract");
	DeleteItem = new JMenuItem("Delete");
	AboutItem = new JMenuItem("About");
	
	// setup the menu items
	AddItem.setActionCommand("Add");
	ExtractItem.setActionCommand("Extract");
	DeleteItem.setActionCommand("Delete");
	AboutItem.setActionCommand("About");
	AddItem.addActionListener(allActionListener);
	ExtractItem.addActionListener(allActionListener);
	DeleteItem.addActionListener(allActionListener);
	AboutItem.addActionListener(allActionListener);
	AddItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	ExtractItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	DeleteItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	AboutItem.setHorizontalTextPosition(AbstractButton.RIGHT);

	// add the menu items
	add(AddItem);
	add(ExtractItem);
	add(DeleteItem);
	addSeparator();
	add(AboutItem);

    }
}



